<?php
/**
 * Eklentinin Widget'ını oluşturur ve yönetir. (Tüm Tasarım Ayarları Entegre Edilmiş Nihai Sürüm)
 */
if ( ! defined( 'ABSPATH' ) ) exit;

class TDMedya_Showroom_Widget extends WP_Widget {

    public function __construct() {
        parent::__construct( 'tdmedyashow_widget', '(TDMedya) Showroom Sayaç', array( 'description' => 'İstatistik sayaçlarını gösterir.' ) );
    }

    public function widget( $args, $instance ) {
        echo $args['before_widget'];

        if ( ! empty( $instance['title'] ) ) {
            echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
        }

        $options = get_option( 'tdmedyashow_settings', array() );
        
        // --- TÜM TASARIM AYARLARINI AL ---
        $theme = isset($options['theme']) ? $options['theme'] : 'light';
        $has_frame = isset($options['frame_enabled']) && $options['frame_enabled'];
        $frame_width = isset($options['frame_width']) ? intval($options['frame_width']) : 1;
        
        // Sayısal değerleri al
        $customer_count = isset($options['customer_count']) ? intval($options['customer_count']) : 0;
        $project_count  = isset($options['project_count']) ? intval($options['project_count']) : 0;
        $service_count  = isset($options['service_count']) ? intval($options['service_count']) : 0;
        $solution_count = isset($options['solution_count']) ? intval($options['solution_count']) : 0;

        // --- DİNAMİK SINIFLARI VE STİLLERİ OLUŞTUR ---
        $wrapper_classes = "tdmedyashow-wrapper theme-{$theme}";
        if ($has_frame) {
            $wrapper_classes .= " has-frames";
        }
        $frame_style = $has_frame ? "border-width: {$frame_width}px;" : "";
        
        // Özel renkleri HER ZAMAN uygula (eğer bir renk girilmişse)
        $inline_styles = "";
        $customer_color = isset($options['customer_color']) ? esc_attr($options['customer_color']) : '';
        $project_color = isset($options['project_color']) ? esc_attr($options['project_color']) : '';
        $service_color = isset($options['service_color']) ? esc_attr($options['service_color']) : '';
        $solution_color = isset($options['solution_color']) ? esc_attr($options['solution_color']) : '';
        
        if ($customer_color || $project_color || $service_color || $solution_color) {
            $inline_styles .= "<style type='text/css'>";
            // Widget'a özel ID kullanarak diğer widget'larla çakışmayı önle
            $widget_id_selector = "#" . esc_attr($args['widget_id']);
            if ($customer_color) { $inline_styles .= "{$widget_id_selector} .customer-number { color: {$customer_color} !important; }"; }
            if ($project_color) { $inline_styles .= "{$widget_id_selector} .project-number { color: {$project_color} !important; }"; }
            if ($service_color) { $inline_styles .= "{$widget_id_selector} .service-number { color: {$service_color} !important; }"; }
            if ($solution_color) { $inline_styles .= "{$widget_id_selector} .solution-number { color: {$solution_color} !important; }"; }
            $inline_styles .= "</style>";
        }

        // Oluşturulan özel renk stillerini bas
        echo $inline_styles;
        ?>
        
        <div id="<?php echo esc_attr($args['widget_id']); ?>" class="<?php echo esc_attr($wrapper_classes); ?>">
            <div class="tdmedyashow-item" style="<?php echo esc_attr($frame_style); ?>">
                <h3 class="tdmedyashow-number customer-number"><?php echo number_format_i18n($customer_count); ?></h3>
                <p class="tdmedyashow-title">Müşteri Sayısı</p>
            </div>
            <div class="tdmedyashow-item" style="<?php echo esc_attr($frame_style); ?>">
                <h3 class="tdmedyashow-number project-number"><?php echo number_format_i18n($project_count); ?></h3>
                <p class="tdmedyashow-title">Proje Sayısı</p>
            </div>
            <div class="tdmedyashow-item" style="<?php echo esc_attr($frame_style); ?>">
                <h3 class="tdmedyashow-number service-number"><?php echo number_format_i18n($service_count); ?></h3>
                <p class="tdmedyashow-title">Hizmet Türü Sayısı</p>
            </div>
            <div class="tdmedyashow-item" style="<?php echo esc_attr($frame_style); ?>">
                <h3 class="tdmedyashow-number solution-number"><?php echo number_format_i18n($solution_count); ?></h3>
                <p class="tdmedyashow-title">Çözüm Sayısı</p>
            </div>
        </div>
        <?php
        echo $args['after_widget'];
    }

    public function form( $instance ) {
        $title = ! empty( $instance['title'] ) ? $instance['title'] : '';
        echo "<p><label for='".esc_attr( $this->get_field_id( 'title' ) )."'>Başlık:</label><input class='widefat' id='".esc_attr( $this->get_field_id( 'title' ) )."' name='".esc_attr( $this->get_field_name( 'title' ) )."' type='text' value='".esc_attr( $title )."'></p>";
        echo "<p>Tüm sayaç ve tasarım ayarları, eklentinin kendi <a href='admin.php?page=tdmedyashow'>ayar sayfasından</a> yönetilir.</p>";
    }

    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        return $instance;
    }
}

// Widget'ı WordPress'e kaydet
add_action( 'widgets_init', function() {
    register_widget( 'TDMedya_Showroom_Widget' );
});