<?php
/**
 * Eklentinin tüm yönetim paneli mantığını içerir. (Sekmesiz, Sade ve Tam Sürüm)
 */
if ( ! defined( 'ABSPATH' ) ) exit;

// 1. Admin menüsünü ve sayfasını ekle
add_action( 'admin_menu', 'tdmedyashow_add_admin_menu' );
function tdmedyashow_add_admin_menu() {
    add_menu_page(
        'TDMedya Showroom',
        'TDMedya Showroom',
        'manage_options',
        'tdmedyashow',
        'tdmedyashow_settings_page_render', // Ayar sayfasını oluşturan fonksiyon
        'dashicons-star-filled',
        30
    );
}

// 2. Ayarları kaydetmek için WordPress'e tanıt
add_action( 'admin_init', 'tdmedyashow_register_settings' );
function tdmedyashow_register_settings() {
    register_setting( 'tdmedyashow_settings_group', 'tdmedyashow_settings', 'tdmedyashow_sanitize_settings' );
}

// 3. Ayar sayfasını oluşturan ana fonksiyon
function tdmedyashow_settings_page_render() {
    // Kayıtlı ayarları alalım
    $options = get_option('tdmedyashow_settings', []);
    ?>
    <div class="wrap">
        <h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
        <form action="options.php" method="post">
            <?php settings_fields( 'tdmedyashow_settings_group' ); ?>

            <h2>Sayılar</h2>
            <table class="form-table" role="presentation">
                <tbody>
                    <tr>
                        <th scope="row"><label for="customer_count">Müşteri Sayısı</label></th>
                        <td><input type="number" id="customer_count" name="tdmedyashow_settings[customer_count]" value="<?php echo isset($options['customer_count']) ? esc_attr($options['customer_count']) : 0; ?>"></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="project_count">Proje Sayısı</label></th>
                        <td><input type="number" id="project_count" name="tdmedyashow_settings[project_count]" value="<?php echo isset($options['project_count']) ? esc_attr($options['project_count']) : 0; ?>"></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="service_count">Hizmet Türü Sayısı</label></th>
                        <td><input type="number" id="service_count" name="tdmedyashow_settings[service_count]" value="<?php echo isset($options['service_count']) ? esc_attr($options['service_count']) : 0; ?>"></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="solution_count">Çözüm Sayısı</label></th>
                        <td><input type="number" id="solution_count" name="tdmedyashow_settings[solution_count]" value="<?php echo isset($options['solution_count']) ? esc_attr($options['solution_count']) : 0; ?>"></td>
                    </tr>
                </tbody>
            </table>

            <hr>

            <h2>Tasarım Ayarları</h2>
            <table class="form-table" role="presentation">
                <tbody>
                    <tr>
                        <th scope="row"><label for="theme">Görünüm Teması</label></th>
                        <td>
                            <select id="theme" name="tdmedyashow_settings[theme]">
                                <?php $selected_theme = isset($options['theme']) ? $options['theme'] : 'light'; ?>
                                <option value="light" <?php selected($selected_theme, 'light'); ?>>Açık Tema</option>
                                <option value="dark" <?php selected($selected_theme, 'dark'); ?>>Koyu Tema</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">Sütun Çerçeveleri</th>
                        <td>
                            <label>
                                <input type="checkbox" name="tdmedyashow_settings[frame_enabled]" <?php checked(isset($options['frame_enabled']) && $options['frame_enabled'], true); ?>>
                                Her bir sütun için çerçeve göster
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="frame_width">Çerçeve Kalınlığı (px)</label></th>
                        <td><input type="number" id="frame_width" name="tdmedyashow_settings[frame_width]" value="<?php echo isset($options['frame_width']) ? esc_attr($options['frame_width']) : 1; ?>"></td>
                    </tr>
                </tbody>
            </table>

            <hr>

            <h2>Rakam Renk Ayarları</h2>
            <p class="description">Bu bölümdeki renkler, seçtiğiniz temadan (Açık/Koyu) bağımsız olarak her zaman önceliklidir. Boş bırakırsanız, temanın varsayılan rengi kullanılır.</p>
            <table class="form-table" role="presentation">
                 <tbody>
                    <tr>
                        <th scope="row"><label for="customer_color">Müşteri Sayısı Rengi</label></th>
                        <td><input type="color" id="customer_color" name="tdmedyashow_settings[customer_color]" value="<?php echo isset($options['customer_color']) ? esc_attr($options['customer_color']) : '#000000'; ?>"></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="project_color">Proje Sayısı Rengi</label></th>
                        <td><input type="color" id="project_color" name="tdmedyashow_settings[project_color]" value="<?php echo isset($options['project_color']) ? esc_attr($options['project_color']) : '#000000'; ?>"></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="service_color">Hizmet Sayısı Rengi</label></th>
                        <td><input type="color" id="service_color" name="tdmedyashow_settings[service_color]" value="<?php echo isset($options['service_color']) ? esc_attr($options['service_color']) : '#000000'; ?>"></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="solution_color">Çözüm Sayısı Rengi</label></th>
                        <td><input type="color" id="solution_color" name="tdmedyashow_settings[solution_color]" value="<?php echo isset($options['solution_color']) ? esc_attr($options['solution_color']) : '#000000'; ?>"></td>
                    </tr>
                </tbody>
            </table>

            <?php submit_button('Değişiklikleri Kaydet'); ?>
        </form>
    </div>
    <?php
}

// 4. Kaydetme fonksiyonu
function tdmedyashow_sanitize_settings( $input ) {
    $sanitized_input = [];
    
    // Gelen tüm ayarları döngüye al ve tipine göre temizle
    foreach( $input as $key => $value ) {
        if ( strpos( $key, '_count' ) !== false || strpos( $key, '_width' ) !== false ) {
            $sanitized_input[$key] = absint( $value );
        } elseif ( strpos( $key, '_color' ) !== false ) {
            $sanitized_input[$key] = sanitize_hex_color( $value );
        } else {
            $sanitized_input[$key] = sanitize_text_field( $value );
        }
    }
    
    // Checkbox'ı kontrol et (eğer formda işaretli gelmediyse, 'false' olarak kaydet)
    $sanitized_input['frame_enabled'] = isset( $input['frame_enabled'] ) ? true : false;

    return $sanitized_input;
}