<?php
/**
 * Plugin Name:       Bukre İndirme Yöneticisi (Nihai Sürüm)
 * Plugin URI:        https://www.bukre.net
 * Description:       Siteniz için özel, modern görünümlü ve tam özellikli dosya indirme yöneticisi.
 * Version:           2.0
 * Author:            Bukre.net & Gemini
 * Author URI:        https://www.bukre.net
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       bukre-indir
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Güvenlik için doğrudan erişimi engelle

// 1. "İndirmeler" Custom Post Type'ını oluşturur
function biyo_register_download_post_type() {
    $labels = array('name' => 'İndirmeler', 'singular_name' => 'İndirme', 'menu_name' => 'İndirmeler', 'name_admin_bar' => 'İndirme', 'add_new' => 'Yeni Ekle', 'add_new_item' => 'Yeni İndirme Ekle', 'new_item' => 'Yeni İndirme', 'edit_item' => 'İndirmeyi Düzenle', 'view_item' => 'İndirmeyi Görüntüle', 'all_items' => 'Tüm İndirmeler', 'search_items' => 'İndirme Ara', 'not_found' => 'Hiç indirme bulunamadı.', 'not_found_in_trash' => 'Çöp kutusunda indirme bulunamadı.');
    $args = array('labels' => $labels, 'public' => true, 'publicly_queryable' => true, 'show_ui' => true, 'show_in_menu' => true, 'query_var' => true, 'rewrite' => array( 'slug' => 'indirmeler' ), 'capability_type' => 'post', 'has_archive' => true, 'hierarchical' => false, 'menu_position' => 20, 'menu_icon' => 'dashicons-download', 'supports' => array( 'title', 'editor' ));
    register_post_type( 'biyo_download', $args );
}
add_action( 'init', 'biyo_register_download_post_type' );

// 2. Meta Kutularını ve Alanlarını Ekler
function biyo_add_download_meta_box() {
    add_meta_box('biyo_download_details_box', 'İndirme Detayları', 'biyo_render_meta_box_content', 'biyo_download', 'normal', 'high');
}
add_action( 'add_meta_boxes', 'biyo_add_download_meta_box' );

function biyo_render_meta_box_content( $post ) {
    wp_nonce_field( 'biyo_save_meta_box_data', 'biyo_meta_box_nonce' );
    $file_url = get_post_meta( $post->ID, '_biyo_file_url', true );
    $download_count = get_post_meta( $post->ID, '_biyo_download_count', true );
    ?>
    <style>.biyo-meta-field{margin-bottom:15px;padding:15px;background-color:#f9f9f9;border:1px solid #ddd; border-radius: 4px;}.biyo-meta-field label{font-weight:bold;display:block;margin-bottom:5px;font-size:14px;}.biyo-meta-field input[type="text"]{padding:8px;}.biyo-meta-field .description{color:#666;font-style:italic;}</style>
    <div class="biyo-meta-field">
        <label for="biyo_file_url_field">Dosya URL'si:</label>
        <input type="text" id="biyo_file_url_field" name="biyo_file_url" value="<?php echo esc_attr( $file_url ); ?>" placeholder="Dosya seçmek için butona tıklayın..." style="width: calc(100% - 130px); margin-right: 10px;" />
        <button type="button" class="button button-primary biyo-media-button">Dosya Seç</button>
        <p class="description">Medya Kütüphanesi'nden bir dosya seçin veya URL'yi elle yapıştırın.</p>
    </div>
    <div class="biyo-meta-field">
        <label>İndirme Sayısı:</label>
        <strong><?php echo empty($download_count) ? '0' : esc_html( $download_count ); ?></strong>
        <p class="description">Bu sayaç, her indirme işleminde otomatik olarak artacaktır.</p>
    </div>
    <?php
}

function biyo_save_meta_box_data( $post_id ) {
    if (!isset($_POST['biyo_meta_box_nonce']) || !wp_verify_nonce($_POST['biyo_meta_box_nonce'], 'biyo_save_meta_box_data')) return;
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (!current_user_can('edit_post', $post_id)) return;
    if (isset($_POST['biyo_file_url'])) {
        update_post_meta($post_id, '_biyo_file_url', esc_url_raw($_POST['biyo_file_url']));
    }
}
add_action( 'save_post', 'biyo_save_meta_box_data' );

// 3. Gerekli Script ve Stil Dosyalarını Yükler
function biyo_enqueue_admin_scripts($hook) {
    global $post_type;
    if (('post.php' == $hook || 'post-new.php' == $hook) && 'biyo_download' == $post_type) {
        wp_enqueue_media();
        wp_enqueue_script('biyo-admin-js', plugin_dir_url(__FILE__).'biyo-admin.js', array('jquery'), '2.0', true);
    }
}
add_action( 'admin_enqueue_scripts', 'biyo_enqueue_admin_scripts' );

function biyo_enqueue_frontend_styles() {
    wp_enqueue_style( 'biyo-frontend-style', plugin_dir_url( __FILE__ ) . 'css/style.css', array(), '2.0', 'all' );
}
add_action( 'wp_enqueue_scripts', 'biyo_enqueue_frontend_styles' );

// 4. Admin Paneli Sütunlarını Ekler ve Doldurur
function biyo_add_admin_columns( $columns ) {
    $new_columns = array();
    foreach ($columns as $key => $title) {
        $new_columns[$key] = $title;
        if ($key == 'title') {
            $new_columns['biyo_shortcode'] = 'Kısa Kod';
            $new_columns['biyo_downloads'] = 'İndirme Sayısı';
        }
    }
    return $new_columns;
}
add_filter( 'manage_biyo_download_posts_columns', 'biyo_add_admin_columns' );

function biyo_fill_admin_columns( $column, $post_id ) {
    switch ( $column ) {
        case 'biyo_shortcode':
            echo '<code style="display:inline-block; padding: 4px 8px; background: #f0f0f0; border-radius: 3px;">[bukre_indir id="' . $post_id . '"]</code>';
            break;
        case 'biyo_downloads':
            $count = get_post_meta( $post_id, '_biyo_download_count', true );
            echo '<strong style="font-size: 1.2em;">' . (empty($count) ? '0' : esc_html($count)) . '</strong>';
            break;
    }
}
add_action( 'manage_biyo_download_posts_custom_column', 'biyo_fill_admin_columns', 10, 2 );

// 5. Kısa Kod ve İndirme Mantığı
function biyo_shortcode_handler( $atts ) {
    $atts = shortcode_atts(array('id' => 0, 'metin' => 'Dosyayı İndir'), $atts, 'bukre_indir');
    $download_id = intval($atts['id']);
    if ($download_id <= 0) return '<p class="biyo-download-error">Hata: Geçerli bir indirme ID\'si belirtilmedi.</p>';
    
    $file_url = get_post_meta($download_id, '_biyo_file_url', true);
    if (empty($file_url)) return '<p class="biyo-download-error">Hata: İndirme için dosya tanımlanmamış.</p>';
    
    $file_size_formatted = '';
    $upload_dir = wp_upload_dir();
    $file_path = str_replace($upload_dir['baseurl'], $upload_dir['basedir'], $file_url);
    if (file_exists($file_path)) {
        $file_size = filesize($file_path);
        $file_size_formatted = ' <span class="biyo-file-size">(' . biyo_format_file_size($file_size) . ')</span>';
    }
    
    $download_trigger_url = add_query_arg(array('biyo_download_action' => 'indir', 'file_id' => $download_id), home_url());

    // HTML Çıktısı
    $output = '<div class="biyo-download-wrapper">';
        $output .= '<div class="biyo-download-icon">';
            // İkon için bir SVG ekleyelim. Font Awesome gerektirmez.
            $output .= '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" width="48" height="48"><path d="M12 15.586l-4.293-4.293a1 1 0 00-1.414 1.414l6 6a1 1 0 001.414 0l6-6a1 1 0 00-1.414-1.414L12 15.586z"/><path d="M12 2a1 1 0 00-1 1v10.586l-2.293-2.293a1 1 0 00-1.414 1.414l4 4a1 1 0 001.414 0l4-4a1 1 0 00-1.414-1.414L13 13.586V3a1 1 0 00-1-1z"/></svg>';
        $output .= '</div>';
        $output .= '<div class="biyo-download-info">';
            $output .= '<span class="biyo-download-title">' . get_the_title($download_id) . '</span>';
            $output .= '<span class="biyo-download-description">İndirmek için butona tıklayın' . $file_size_formatted . '</span>';
        $output .= '</div>';
        $output .= '<div class="biyo-download-action">';
            $output .= '<a href="' . esc_url($download_trigger_url) . '" class="biyo-download-button" rel="nofollow">' . esc_html($atts['metin']) . '</a>';
        $output .= '</div>';
    $output .= '</div>';

    return $output;
}
add_shortcode( 'bukre_indir', 'biyo_shortcode_handler' );

function biyo_handle_download_request() {
    if (isset($_GET['biyo_download_action']) && $_GET['biyo_download_action'] === 'indir' && isset($_GET['file_id'])) {
        $download_id = intval($_GET['file_id']);
        $file_url = get_post_meta($download_id, '_biyo_file_url', true);
        if (empty($file_url)) wp_die('Hata: İndirilecek dosya bulunamadı.');
        $current_count = get_post_meta($download_id, '_biyo_download_count', true);
        $new_count = empty($current_count) ? 1 : intval($current_count) + 1;
        update_post_meta($download_id, '_biyo_download_count', $new_count);
        header("Location: " . $file_url);
        exit();
    }
}
add_action( 'template_redirect', 'biyo_handle_download_request' );

// 6. Yardımcı Fonksiyon: Dosya Boyutunu Formatlama
function biyo_format_file_size($bytes) {
    if ($bytes >= 1073741824) $bytes = number_format($bytes / 1073741824, 2) . ' GB';
    elseif ($bytes >= 1048576) $bytes = number_format($bytes / 1048576, 2) . ' MB';
    elseif ($bytes >= 1024) $bytes = number_format($bytes / 1024, 1) . ' KB';
    elseif ($bytes > 1) $bytes = $bytes . ' bytes';
    elseif ($bytes == 1) $bytes = $bytes . ' byte';
    else $bytes = '0 bytes';
    return $bytes;
}